// Borland C++ Builder
// Copyright (c) 1995, 2005 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Idsockethandle.pas' rev: 10.00

#ifndef IdsockethandleHPP
#define IdsockethandleHPP

#pragma delphiheader begin
#pragma option push
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member functions
#pragma pack(push,8)
#include <System.hpp>	// Pascal unit
#include <Sysinit.hpp>	// Pascal unit
#include <Idexception.hpp>	// Pascal unit
#include <Idglobal.hpp>	// Pascal unit
#include <Idstackconsts.hpp>	// Pascal unit
#include <Idstack.hpp>	// Pascal unit
#include <Idsys.hpp>	// Pascal unit
#include <Idobjs.hpp>	// Pascal unit
#include <Idbasecomponent.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Idsockethandle
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS TIdSocketHandles;
class DELPHICLASS TIdSocketHandle;
class PASCALIMPLEMENTATION TIdSocketHandles : public Classes::TOwnedCollection 
{
	typedef Classes::TOwnedCollection inherited;
	
public:
	TIdSocketHandle* operator[](int Index) { return Items[Index]; }
	
protected:
	int FDefaultPort;
	HIDESBASE TIdSocketHandle* __fastcall GetItem(int Index);
	HIDESBASE void __fastcall SetItem(int Index, const TIdSocketHandle* Value);
	
public:
	__fastcall TIdSocketHandles(Classes::TComponent* AOwner);
	HIDESBASE TIdSocketHandle* __fastcall Add(void);
	TIdSocketHandle* __fastcall BindingByHandle(const int AHandle);
	__property TIdSocketHandle* Items[int Index] = {read=GetItem, write=SetItem/*, default*/};
	__property int DefaultPort = {read=FDefaultPort, write=FDefaultPort, nodefault};
public:
	#pragma option push -w-inl
	/* TCollection.Destroy */ inline __fastcall virtual ~TIdSocketHandles(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TIdSocketHandle : public Classes::TCollectionItem 
{
	typedef Classes::TCollectionItem inherited;
	
protected:
	int FClientPortMin;
	int FClientPortMax;
	int FHandle;
	bool FHandleAllocated;
	AnsiString FIP;
	AnsiString FPeerIP;
	int FPort;
	int FPeerPort;
	Idstack::TIdSocketList* FReadSocketList;
	bool FOverLapped;
	Idglobal::TIdIPVersion FIPVersion;
	Syncobjs::TCriticalSection* FConnectionHandle;
	bool __fastcall BindPortReserved(void);
	void __fastcall SetOverLapped(const bool AValue);
	void __fastcall SetHandle(int AHandle);
	void __fastcall SetIPVersion(const Idglobal::TIdIPVersion Value);
	bool __fastcall TryBind(void);
	
public:
	bool __fastcall Accept(int ASocket);
	void __fastcall AllocateSocket(const int ASocketType = 0x1, const int AProtocol = 0x0);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	void __fastcall Bind(void);
	virtual void __fastcall CloseSocket(void);
	virtual void __fastcall Connect(void);
	__fastcall virtual TIdSocketHandle(Classes::TCollection* ACollection);
	__fastcall virtual ~TIdSocketHandle(void);
	void __fastcall Listen(const int anQueueCount = 0x5);
	bool __fastcall Readable(int AMSec = 0xffffffff);
	int __fastcall Receive(Idglobal::TBytes &VBuffer);
	int __fastcall RecvFrom(Idglobal::TBytes &ABuffer, AnsiString &VIP, int &VPort, const Idglobal::TIdIPVersion AIPVersion = (Idglobal::TIdIPVersion)(0x0));
	void __fastcall Reset(const bool AResetLocal = true);
	int __fastcall Send(const Idglobal::TBytes ABuffer, int AOffset, int ASize = 0xffffffff);
	void __fastcall SendTo(const AnsiString AIP, const int APort, const Idglobal::TBytes ABuffer, const Idglobal::TIdIPVersion AIPVersion = (Idglobal::TIdIPVersion)(0x0));
	void __fastcall SetPeer(const AnsiString AIP, const int APort, const Idglobal::TIdIPVersion AIPVersion = (Idglobal::TIdIPVersion)(0x0));
	void __fastcall SetBinding(const AnsiString AIP, const int APort, const Idglobal::TIdIPVersion AIPVersion = (Idglobal::TIdIPVersion)(0x0));
	void __fastcall GetSockOpt(int ALevel, int AOptName, /* out */ int &VOptVal);
	void __fastcall SetSockOpt(int ALevel, int AOptName, int AOptVal);
	bool __fastcall Select(int ATimeout = 0xfffffffe);
	void __fastcall UpdateBindingLocal(void);
	void __fastcall UpdateBindingPeer(void);
	__property bool HandleAllocated = {read=FHandleAllocated, nodefault};
	__property int Handle = {read=FHandle, nodefault};
	__property bool OverLapped = {read=FOverLapped, write=SetOverLapped, nodefault};
	__property AnsiString PeerIP = {read=FPeerIP};
	__property int PeerPort = {read=FPeerPort, nodefault};
	
__published:
	__property int ClientPortMin = {read=FClientPortMin, write=FClientPortMin, default=0};
	__property int ClientPortMax = {read=FClientPortMax, write=FClientPortMax, default=0};
	__property AnsiString IP = {read=FIP, write=FIP};
	__property Idglobal::TIdIPVersion IPVersion = {read=FIPVersion, write=SetIPVersion, default=0};
	__property int Port = {read=FPort, write=FPort, nodefault};
};


//-- var, const, procedure ---------------------------------------------------

}	/* namespace Idsockethandle */
using namespace Idsockethandle;
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Idsockethandle
